/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.block;

import dev.ftb.extendedexchange.block.entity.AbstractEMCBlockEntity;
import dev.ftb.extendedexchange.block.entity.AbstractLinkBlockEntity;
import dev.ftb.extendedexchange.block.entity.TickingEXBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractEXBlock
extends BaseEntityBlock {
    public AbstractEXBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(5.0f).m_60918_(SoundType.f_56742_));
    }

    public AbstractEXBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            AbstractEMCBlockEntity emc;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof AbstractEMCBlockEntity && (emc = (AbstractEMCBlockEntity)blockEntity) instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)emc;
                if (emc instanceof AbstractLinkBlockEntity) {
                    AbstractLinkBlockEntity link = (AbstractLinkBlockEntity)emc;
                    if (!player.m_142081_().equals(link.getOwnerId())) {
                        player.m_5661_((Component)new TextComponent(link.getOwnerName()), true);
                        return InteractionResult.FAIL;
                    }
                }
                NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)menuProvider, (BlockPos)pos);
            }
        }
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, blockEntity) -> {
            if (blockEntity instanceof TickingEXBlockEntity) {
                TickingEXBlockEntity ticker = (TickingEXBlockEntity)blockEntity;
                ticker.tickCommonPre();
                if (level1.m_5776_()) {
                    ticker.tickClient();
                } else {
                    ticker.tickServer();
                }
                ticker.tickCommonPost();
            }
        };
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        BlockEntity blockEntity;
        if (entity != null && (blockEntity = level.m_7702_(pos)) instanceof AbstractLinkBlockEntity) {
            AbstractLinkBlockEntity link = (AbstractLinkBlockEntity)blockEntity;
            link.setOwner(entity);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!state.m_60713_(newState.m_60734_()) && (blockEntity = world.m_7702_(pos)) instanceof AbstractEMCBlockEntity) {
            AbstractEMCBlockEntity invBe = (AbstractEMCBlockEntity)blockEntity;
            Containers.m_19010_((Level)world, (BlockPos)pos, invBe.getContentsToDrop());
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }
}

